#include "StdAfx.h"
#include "scriptHeaders.h"
#include <stdlib.h>
#include <stdio.h>
#include ".\asmutils.h"
#include "functioninstance.h"
//****************************************************************************************************************
//Konstruktor
//****************************************************************************************************************
CFunctionInstance::CFunctionInstance(void)
{
	status = STATUS_RUNNING;						//status nastav na running, coz znamena ze funkce je aktivni
													//instanci funkce vyuziva jen seznam bezicich funkci, takze
													//pokud je funkce v tomto seznamu,musi se provadet
	function = NULL;
	iCurrActivation = 0;

	Stack.Init(MAX_STACK_SIZE);						//inicializace zasobniku pro provadeni vypoctu a ulozeni promennych
	ActivationStack.Init(MAX_RECURSION_DEPTH);		//inicializace zasobniku pro ukladabi volani fci
}
//****************************************************************************************************************
//Destruktor
//****************************************************************************************************************
CFunctionInstance::~CFunctionInstance(void)
{
}
//****************************************************************************************************************
//fce pro snizeni vrcholu zasobniku volani fci
//****************************************************************************************************************
void CFunctionInstance::PopActivation()
{
	iCurrActivation--;
	if (iCurrActivation < 0)		//kontroluj at se nedostanem pod prvni prvek
		iCurrActivation = 0;
}
//****************************************************************************************************************
//nastavi novy vrchol zasobniku pro volani fci
//****************************************************************************************************************
HRESULT CFunctionInstance::PushActivation()
{
	iCurrActivation++;
	if (iCurrActivation > MAX_RECURSION_DEPTH)		//kontroluje velikost zasobniku
	{
		iCurrActivation = MAX_RECURSION_DEPTH;
		return ERR_STACKOVERFLOW;
	}
	return S_OK;
}
//****************************************************************************************************************
//fce pro snizeni vrcholu zasobniku pro vypocty o number 
//****************************************************************************************************************
void CFunctionInstance::Pop(int number)
{
	ActivationStack[iCurrActivation].SP -= number;
	if (ActivationStack[iCurrActivation].SP < -1)
		ActivationStack[iCurrActivation].SP = -1;
}
//****************************************************************************************************************
//ulozi na vrchol zasobniku integer
//****************************************************************************************************************
void CFunctionInstance::PushInt(int i)
{
	Stack[++(ActivationStack[iCurrActivation].SP)].intval = i;
	Stack[ActivationStack[iCurrActivation].SP].kind = INT_CONST;
}
//****************************************************************************************************************
//ulozi na vrchol zasobniku retezec
//****************************************************************************************************************
void CFunctionInstance::PushString(char* str)
{
	Stack[++(ActivationStack[iCurrActivation].SP)].strval = new char[strlen(str) + 1];
	strcpy(Stack[ActivationStack[iCurrActivation].SP].strval,str);
	Stack[ActivationStack[iCurrActivation].SP].kind = ZSTRING_CONST;
}
//****************************************************************************************************************
//ulozi na vrchol zasobniku double
//****************************************************************************************************************
void CFunctionInstance::PushDouble(double i)
{
	Stack[++(ActivationStack[iCurrActivation].SP)].doubleval = i;
	Stack[ActivationStack[iCurrActivation].SP].kind = DOUBLE_CONST;
}
//****************************************************************************************************************
//uloyzi na vrchol zasobniku polozku
//****************************************************************************************************************
void CFunctionInstance::PushStackItem(StackItem s)
{
	Stack[++(ActivationStack[iCurrActivation].SP)] = s;
}
//****************************************************************************************************************
//vrati integer z vrcholu zasobniku
//****************************************************************************************************************
int CFunctionInstance::PopInt()
{
	int iSP = ActivationStack[iCurrActivation].SP;
	if ((iSP - 1) < 0)
		return 0;
	else
		return Stack[(ActivationStack[iCurrActivation].SP)--].intval;
}
//****************************************************************************************************************
//vrati retezec z vrcholu zasobniku
//****************************************************************************************************************
char* CFunctionInstance::PopString()
{
	int iSP = ActivationStack[iCurrActivation].SP;
	if ((iSP - 1) < 0)
		return "";
	else
	{
		char* str = new char[strlen(Stack[ActivationStack[iCurrActivation].SP].strval) + 1];
		strcpy(str,Stack[(ActivationStack[iCurrActivation].SP)--].strval);
		return str;
	}
}
//****************************************************************************************************************
//vrati double z vrcholu zasobniku
//****************************************************************************************************************
double CFunctionInstance::PopDouble()
{
	int iSP = ActivationStack[iCurrActivation].SP;
	if ((iSP - 1) < 0)
		return 0.0;
	else
		return Stack[(ActivationStack[iCurrActivation].SP)--].doubleval;
}
//****************************************************************************************************************
//vrati polozku z vrcholu zasobniku
//****************************************************************************************************************
StackItem CFunctionInstance::PopStackItem()
{
	int iSP = ActivationStack[iCurrActivation].SP;
	if ((iSP - 1) < 0)
	{
		StackItem pItem;
		pItem.kind = INT_CONST;
		pItem.intval = 0;
		return pItem;
	}
	else
		return Stack[(ActivationStack[iCurrActivation].SP)--];
}
//****************************************************************************************************************
//nastavi poloku v zasobniku na integer
//****************************************************************************************************************
void CFunctionInstance::SetInt(int i, int offset)	
{
	Stack[ActivationStack[iCurrActivation].SP + offset].kind = INT_CONST;
	Stack[ActivationStack[iCurrActivation].SP + offset].intval = i;
}
//****************************************************************************************************************
//nastavi polozku v zasobniku na retezec
//****************************************************************************************************************
void CFunctionInstance::SetString(char* s, int offset)
{
	Stack[ActivationStack[iCurrActivation].SP + offset].kind = ZSTRING_CONST;
	Stack[ActivationStack[iCurrActivation].SP + offset].strval = new char[strlen(s) + 1];
	strcpy(Stack[ActivationStack[iCurrActivation].SP + offset].strval,s);
}
//****************************************************************************************************************
//nastavi polozku v zasobniku na double
//****************************************************************************************************************
void CFunctionInstance::SetDouble(double i,int offset)
{
	Stack[ActivationStack[iCurrActivation].SP].kind = DOUBLE_CONST;
	Stack[ActivationStack[iCurrActivation].SP].doubleval = i;
}
//****************************************************************************************************************
//nastavi polozku v zasobniku
//****************************************************************************************************************
void CFunctionInstance::SetStackItem(StackItem s,int offset) 
{
	Stack[ActivationStack[iCurrActivation].SP + offset] = s;
}
//****************************************************************************************************************
//vrati integer ze zasobniku
//****************************************************************************************************************
int	CFunctionInstance::GetInt(int offset)
{
	return Stack[ActivationStack[iCurrActivation].SP + offset].intval;
}
//****************************************************************************************************************
//vrati retzec ze zasobniku
//****************************************************************************************************************
char* CFunctionInstance::GetString(int offset)
{
	char* str = new char[strlen(Stack[ActivationStack[iCurrActivation].SP + offset].strval) + 1];
	strcpy(str,Stack[ActivationStack[iCurrActivation].SP + offset].strval);
	return str;
}
//****************************************************************************************************************
//vrati double ze zasobniku
//****************************************************************************************************************
double CFunctionInstance::GetDouble(int offset)
{
	return Stack[ActivationStack[iCurrActivation].SP + offset].doubleval;
}
//****************************************************************************************************************
//vrati polozku ze zasobniku
//****************************************************************************************************************
StackItem CFunctionInstance::GetStackItem(int offset)
{
	return Stack[ActivationStack[iCurrActivation].SP + offset];
}
//****************************************************************************************************************
//vrati integer promennou
//****************************************************************************************************************
int	CFunctionInstance::GetLocalInt(int offset)
{
	return Stack[ActivationStack[iCurrActivation].BSP + offset].intval;
}
//****************************************************************************************************************
//vrati retezcovou promennou
//****************************************************************************************************************
char* CFunctionInstance::GetLocalString(int offset )	
{
	char* str = new char[strlen(Stack[ActivationStack[iCurrActivation].BSP + offset].strval) + 1];
	strcpy(str,Stack[ActivationStack[iCurrActivation].BSP + offset].strval);
	return str;
}
//****************************************************************************************************************
//vrati double promennou
//****************************************************************************************************************
double CFunctionInstance::GetLocalDouble(int offset)
{
	return Stack[ActivationStack[iCurrActivation].BSP + offset].doubleval;
}
//****************************************************************************************************************
//ulozi integer promennou
//****************************************************************************************************************
void CFunctionInstance::SetLocalInt(int i, int offset)
{
	Stack[ActivationStack[iCurrActivation].BSP + offset].kind = INT_CONST;
	Stack[ActivationStack[iCurrActivation].BSP + offset].intval = i;
}
//****************************************************************************************************************
//ulozi retezcovou promennou
//****************************************************************************************************************
void CFunctionInstance::SetLocalString(char* s, int offset)
{
	Stack[ActivationStack[iCurrActivation].BSP + offset].kind = ZSTRING_CONST;
	Stack[ActivationStack[iCurrActivation].BSP + offset].strval = new char[strlen(s) + 1];
	strcpy(Stack[ActivationStack[iCurrActivation].BSP + offset].strval,s);
}
//****************************************************************************************************************
//ulozi double promennou
//****************************************************************************************************************
void CFunctionInstance::SetLocalDouble(double i, int offset)
{
	Stack[ActivationStack[iCurrActivation].BSP + offset].kind = DOUBLE_CONST;
	Stack[ActivationStack[iCurrActivation].BSP + offset].doubleval = i;
}
//****************************************************************************************************************
//vrati tzp hodnoty v zasobniku
//****************************************************************************************************************
int	CFunctionInstance::GetStackVariableKind(int offset)
{
	return Stack[ActivationStack[iCurrActivation].SP + offset].kind;
}
//****************************************************************************************************************
//vrati typ promenne
//****************************************************************************************************************
int	CFunctionInstance::GetLocalVariableKind(int offset)
{
	return Stack[ActivationStack[iCurrActivation].BSP + offset].kind;
}

//****************************************************************************************************************
//****************************************************************************************************************
//*****************************************************Trida StackItem********************************************
//****************************************************************************************************************
//****************************************************************************************************************
//Tady jsou vetsinou jen pretizene operatory pro prislusejici operace. V kazdem operatoru
//se nejdrive divame na typ hodnoty ktera je vlevo, pak na typ hodnoty ktera je vpravo a podle
//toho se rozhodneme co delat. Vetsinou se provede pretypovani, aby byly obe hodnoty stejenho typu,
//provede se pozadovana operace a vrati se vysledek. V telech operatoru se tedy deji veskere datove konverze
//skriptovaci jazyk datove typy nezna a umoznuje tak delit treba double retezcem, takove pripady jsou zachyceny
//tady a hodnoty jsou pretzpovany. Nebudu popisovat kazdy operator zvlast, pac je to vsechno skoro stejny a kdyz
//se na to podivame, zjistime jednoduse co se deje a z ceho na co se pretypovava. Pravidla pro pretypovani jsou taka
//jaka jsem je chtel mit, ne ze by to tak muselo bejt. Retezce pretypovavam na double, protoze nevim jestli v nich je napsan
//inetegr, double nebo jestli to neni cislo. Radsi udelam double aby nedochazelo ke ztrate dat, pokud to cislo nebude  vubec
//fce atof vrati stejne 0
//****************************************************************************************************************
//operator ==
//****************************************************************************************************************
bool StackItem::operator == (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval == right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval == right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval == right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval == (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval == right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval == right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) == 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) == 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) == 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//operator !=
//****************************************************************************************************************
bool StackItem::operator != (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval != right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval != right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval != right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval != (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval != right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval != right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) != 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) != 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) != 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//operator <
//****************************************************************************************************************
bool StackItem::operator < (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval < right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval < right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval < right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval < (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval < right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval < right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) < 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) < 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) < 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//operator >
//****************************************************************************************************************
bool StackItem::operator > (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval > right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval > right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval > right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval > (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval > right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval > right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) > 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) > 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) > 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//operator <=
//****************************************************************************************************************
bool StackItem::operator <= (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval <= right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval <= right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval <= right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval <= (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval <= right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval <= right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) <= 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) <= 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) <= 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//operator >=
//****************************************************************************************************************
bool StackItem::operator >= (StackItem &right)
{
	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (intval >= right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if ((double)intval >= right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtoint();
			if (intval >= right.intval)
				return true;
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			if (doubleval >= (double)right.intval)
				return true;
			break;
		case DOUBLE_CONST:
			if (doubleval >= right.doubleval)
				return true;
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			if (doubleval >= right.doubleval)
				return true;
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			if (strcmp(strval,right.strval) >= 0)
				return true;
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			if (strcmp(strval,right.strval) >= 0)
				return true;
			break;
		case ZSTRING_CONST:
			if (strcmp(strval,right.strval) >= 0)
				return true;
			break;
		}
		break;
	}

	return false;
}
//****************************************************************************************************************
//pretypovani z integer  na double
//****************************************************************************************************************
void StackItem::Cast_inttodouble()
{
	doubleval = (double)intval;
	kind = DOUBLE_CONST;
}
//****************************************************************************************************************
//pretypovani z integer na retezec
//****************************************************************************************************************
void StackItem::Cast_inttostring()
{
	char* buffer = new char[128];
	sprintf(buffer,"%i",intval);
	strval = buffer;
	kind = ZSTRING_CONST;
}
//****************************************************************************************************************
//pretypovani z double na integer
void StackItem::Cast_doubletoint()
{
	intval = (int)doubleval;
	kind = INT_CONST;
}
//****************************************************************************************************************
//pretypovani z double na retezec
//****************************************************************************************************************
void StackItem::Cast_doubletostring()
{
	char* buffer = new char[128];
	sprintf(buffer,"%f",doubleval);
	strval = buffer;
	kind = ZSTRING_CONST;
}
//****************************************************************************************************************
//pretypovani z retezce na double
//****************************************************************************************************************
void StackItem::Cast_stringtodouble()
{
	doubleval = atof(strval);
	kind = DOUBLE_CONST;
}
//****************************************************************************************************************
//pretypovani z retezce na integer
//****************************************************************************************************************
void StackItem::Cast_stringtoint()
{
	intval = atoi(strval);
	kind = INT_CONST;
}
//****************************************************************************************************************
//operator nasobeni
//****************************************************************************************************************
StackItem StackItem::operator * (StackItem &right)
{
	StackItem result;

	switch (kind)		//nejdriv se budeme royhodovat podle toho jaky datovy typ ma promenna vlevo
	{
	case INT_CONST:			//vlevo je integer nebo bool
		switch (right.kind)	//ted se podivame co je vpravo
		{	
		case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
			result.kind = INT_CONST;
			result.intval = (intval * right.intval);
			break;
		case DOUBLE_CONST:		//pokud je to double
			Cast_inttodouble();	//pretypuj levy operand na double
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		case ZSTRING_CONST:		//jde o retezec
			Cast_inttodouble();	//levou stranu na double
			right.Cast_stringtodouble();	//pravou stranu na double. Nevim jestli je v retezci int nebo double cislo,
										//tak radsi pretypujeme na double aby nedoslo ke ztrate dat
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		}
		break;
	case ZSTRING_CONST:
		//reteze v kazdem pripade pretypujeme na double
		Cast_stringtodouble();
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval * right.doubleval);
			break;
		}
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator deleni
//****************************************************************************************************************
StackItem StackItem::operator / (StackItem &right)
{
	StackItem result;

	switch (kind)		//nejdriv se budeme royhodovat podle toho jaky datovy typ ma promenna vlevo
	{
	case INT_CONST:			//vlevo je integer nebo bool
		switch (right.kind)	//ted se podivame co je vpravo
		{	
		case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
			result.kind = INT_CONST;
			result.intval = (intval / right.intval);
			break;
		case DOUBLE_CONST:		//pokud je to double
			Cast_inttodouble();	//pretypuj levy operand na double
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		case ZSTRING_CONST:		//jde o retezec
			Cast_inttodouble();	//levou stranu na double
			right.Cast_stringtodouble();	//pravou stranu na double. Nevim jestli je v retezci int nebo double cislo,
										//tak radsi pretypujeme na double aby nedoslo ke ztrate dat
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		}
		break;
	case ZSTRING_CONST:
		//reteze v kazdem pripade pretypujeme na double
		Cast_stringtodouble();
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval / right.doubleval);
			break;
		}
		break;
	}
	return result;
}
//****************************************************************************************************************
//operator scitani
//****************************************************************************************************************
StackItem StackItem::operator + (StackItem &right)
{
	StackItem result;

	switch (kind)
	{
	case INT_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			result.kind = INT_CONST;
			result.intval = (intval + right.intval);
			break;
		case DOUBLE_CONST:
			Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval + right.doubleval);
			break;
		case ZSTRING_CONST:
			Cast_inttodouble();
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval + right.doubleval);
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval + right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval +  right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval + right.doubleval);
			break;
		}
		break;
	case ZSTRING_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttostring();
			result.kind = ZSTRING_CONST;
			result.strval = stringConcat(strval,right.strval,NULL);
			break;
		case DOUBLE_CONST:
			right.Cast_doubletostring();
			result.kind = ZSTRING_CONST;
			result.strval = stringConcat(strval,right.strval,NULL);
			break;
		case ZSTRING_CONST:
			result.kind = ZSTRING_CONST;
			result.strval = stringConcat(strval,right.strval,NULL);
			break;
		}
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator odcitani
//****************************************************************************************************************
StackItem StackItem::operator - (StackItem &right)
{
	StackItem result;

	switch (kind)		//nejdriv se budeme royhodovat podle toho jaky datovy typ ma promenna vlevo
	{
	case INT_CONST:			//vlevo je integer nebo bool
		switch (right.kind)	//ted se podivame co je vpravo
		{	
		case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
			result.kind = INT_CONST;
			result.intval = (intval - right.intval);
			break;
		case DOUBLE_CONST:		//pokud je to double
			Cast_inttodouble();	//pretypuj levy operand na double
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		case ZSTRING_CONST:		//jde o retezec
			Cast_inttodouble();	//levou stranu na double
			right.Cast_stringtodouble();	//pravou stranu na double. Nevim jestli je v retezci int nebo double cislo,
										//tak radsi pretypujeme na double aby nedoslo ke ztrate dat
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		}
		break;
	case DOUBLE_CONST:
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		}
		break;
	case ZSTRING_CONST:
		//reteze v kazdem pripade pretypujeme na double
		Cast_stringtodouble();
		switch (right.kind)
		{
		case INT_CONST:
			right.Cast_inttodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		case DOUBLE_CONST:
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		case ZSTRING_CONST:
			right.Cast_stringtodouble();
			result.kind = DOUBLE_CONST;
			result.doubleval = (doubleval - right.doubleval);
			break;
		}
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator zbytek po celociselnem deleni
//****************************************************************************************************************
StackItem StackItem::operator % (StackItem &right)
{
	StackItem result;

	if (kind == DOUBLE_CONST)
		Cast_doubletoint();
	else if (kind == ZSTRING_CONST)
		Cast_stringtoint();

			//vlevo je integer nebo bool
	switch (right.kind)	//ted se podivame co je vpravo
	{	
	case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
		result.kind = INT_CONST;
		result.intval = (intval % right.intval);
		break;
	case DOUBLE_CONST:		//pokud je to double
		right.Cast_doubletoint();
		result.kind = INT_CONST;
		result.intval = (intval % right.intval);
		break;
	case ZSTRING_CONST:		//jde o retezec
		right.Cast_stringtoint();
		result.kind = INT_CONST;
		result.intval = (intval % right.intval);
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator bitovy posun vlevo
//****************************************************************************************************************
StackItem StackItem::operator << (StackItem &right)
{
	StackItem result;

	if (kind == DOUBLE_CONST)
		Cast_doubletoint();
	else if (kind == ZSTRING_CONST)
		Cast_stringtoint();

	switch (right.kind)	//ted se podivame co je vpravo
	{	
	case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
		result.kind = INT_CONST;
		result.intval = (intval << right.intval);
		break;
	case DOUBLE_CONST:		//pokud je to double
		right.Cast_doubletoint();
		result.kind = INT_CONST;
		result.intval = (intval << right.intval);
		break;
	case ZSTRING_CONST:		//jde o retezec
		right.Cast_stringtoint();
		result.kind = INT_CONST;
		result.intval = (intval << right.intval);
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator bitovy posun vpravo
//****************************************************************************************************************
StackItem StackItem::operator >> (StackItem &right)
{
	StackItem result;

	if (kind == DOUBLE_CONST)
		Cast_doubletoint();
	else if (kind == ZSTRING_CONST)
		Cast_stringtoint();

	switch (right.kind)	//ted se podivame co je vpravo
	{	
	case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
		result.kind = INT_CONST;
		result.intval = (intval >> right.intval);
		break;
	case DOUBLE_CONST:		//pokud je to double
		right.Cast_doubletoint();
		result.kind = INT_CONST;
		result.intval = (intval >> right.intval);
		break;
	case ZSTRING_CONST:		//jde o retezec
		right.Cast_stringtoint();
		result.kind = INT_CONST;
		result.intval = (intval >> right.intval);
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator logicky soucin
//****************************************************************************************************************
StackItem StackItem::operator & (StackItem &right)
{
	StackItem result;

	if (kind == DOUBLE_CONST)
		Cast_doubletoint();
	else if (kind == ZSTRING_CONST)
		Cast_stringtoint();

	switch (right.kind)	//ted se podivame co je vpravo
	{	
	case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
		result.kind = INT_CONST;
		result.intval = (intval & right.intval);
		break;
	case DOUBLE_CONST:		//pokud je to double
		right.Cast_doubletoint();
		result.kind = INT_CONST;
		result.intval = (intval & right.intval);
		break;
	case ZSTRING_CONST:		//jde o retezec
		right.Cast_stringtoint();
		result.kind = INT_CONST;
		result.intval = (intval & right.intval);
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator logicky soucet
//****************************************************************************************************************
StackItem StackItem::operator | (StackItem &right)
{
	StackItem result;

	if (kind == DOUBLE_CONST)
		Cast_doubletoint();
	else if (kind == ZSTRING_CONST)
		Cast_stringtoint();

	switch (right.kind)	//ted se podivame co je vpravo
	{	
	case INT_CONST:			//pokud je tam zase integer, je to v poradku a cisla normalne vynasobime
		result.kind = INT_CONST;
		result.intval = (intval | right.intval);
		break;
	case DOUBLE_CONST:		//pokud je to double
		right.Cast_doubletoint();
		result.kind = INT_CONST;
		result.intval = (intval | right.intval);
		break;
	case ZSTRING_CONST:		//jde o retezec
		right.Cast_stringtoint();
		result.kind = INT_CONST;
		result.intval = (intval | right.intval);
		break;
	}

	return result;
}
//****************************************************************************************************************
//operator prirazeni
//****************************************************************************************************************
void StackItem::operator = (StackItem &right)
{
	switch (right.kind)
	{
	case INT_CONST:
		intval = right.intval;
		break;
	case DOUBLE_CONST:
		doubleval = right.doubleval;
		break;
	case ZSTRING_CONST:
		strval = new char[strlen(right.strval) + 1];
		strcpy(strval,right.strval);
		break;
	}

	kind = right.kind;

	return;
}
//****************************************************************************************************************
//operator prefix dekrementace
//****************************************************************************************************************
StackItem& StackItem::operator -- ()
{
	switch (kind)
	{
	case INT_CONST:
		intval--;
		break;
	case DOUBLE_CONST:
		doubleval--;
		break;
	case ZSTRING_CONST:
		Cast_stringtodouble();
		kind = DOUBLE_CONST;
		doubleval--;
		break;
	}

	return *this;
}
//****************************************************************************************************************
//operator postfix dekrementace
//****************************************************************************************************************
StackItem StackItem::operator -- (int)
{
	StackItem temp = *this;
	--*this;
	return temp;
}
//****************************************************************************************************************
//operator prefix inkrementace
//****************************************************************************************************************
StackItem& StackItem::operator ++ ()
{
	switch (kind)
	{
	case INT_CONST:
		intval++;
		break;
	case DOUBLE_CONST:
		doubleval++;
		break;
	case ZSTRING_CONST:
		Cast_stringtodouble();
		kind = DOUBLE_CONST;
		doubleval++;
		break;
	}

	return *this;
}
//****************************************************************************************************************
//operator postfix inkrementace
//****************************************************************************************************************
StackItem StackItem::operator ++ (int)
{
	StackItem temp = *this;
	++*this;
	return temp;
}